require "TimedActions/ISBaseTimedAction"

TABAS_ClimbOverTubEdge = ISBaseTimedAction:derive("TABAS_ClimbOverTubEdge")

local TABAS_Utils = require("TABAS_Utils")
local TABAS_GT = require("TABAS_GameTimes")

function TABAS_ClimbOverTubEdge:isValid()
    return self.tfc_Base and not self.tfc_Base.bathObject:getModData().using
end

function TABAS_ClimbOverTubEdge:switchSquareSolid()
    if not self.enter then return end

    local prop = self.targetSqr:getProperties()
    if not self.started and self.targetSqr:isSolidTrans() then
        prop:UnSet(IsoFlagType.solidtrans)
    else
        -- prop:Set("solidtrans")
        self.targetSqr:RecalcPropertiesIfNeeded()
    end
end

function TABAS_ClimbOverTubEdge:adjustPosition(direction)
    local x, y
    if self.enter then
        x = self.prevSqr:getX() + 0.5
        y = self.prevSqr:getY() + 0.5
        if direction == IsoDirections.S then
            y = y + 0.15
        elseif direction == IsoDirections.E then
            x = x + 0.15
        elseif direction == IsoDirections.N then
            y = y - 0.15
        else 
            x = x - 0.15
        end
    else
        x = self.targetSqr:getX() + 0.5
        y = self.targetSqr:getY() + 0.5
        if direction == IsoDirections.S then
            y = y + 0.025
        elseif direction == IsoDirections.E then
            x = x + 0.025
        elseif direction == IsoDirections.N then
            y = y - 0.025
        else 
            x = x - 0.025
        end
    end
    TABAS_Utils.setPlayerPosition(self.character, x, y)
    print("Adjust Position: {X = " .. x .. ", Y = " .. y .. "}")
end

function TABAS_ClimbOverTubEdge:getFacingDirection()
    if self.enter then
        if (self.prevSqr:getX() - self.targetSqr:getX()) <= -1 then return IsoDirections.E
        elseif (self.prevSqr:getX() - self.targetSqr:getX()) >= 1 then return IsoDirections.W
        elseif (self.prevSqr:getY() - self.targetSqr:getY()) <= -1 then return IsoDirections.S
        else return IsoDirections.N
        end
    else
        if (self.prevSqr:getX() - self.targetSqr:getX()) <= -1 then return IsoDirections.W
        elseif (self.prevSqr:getX() - self.targetSqr:getX()) >= 1 then return IsoDirections.E
        elseif (self.prevSqr:getY() - self.targetSqr:getY()) <= -1 then return IsoDirections.N
        else return IsoDirections.S
        end
    end
end


function TABAS_ClimbOverTubEdge:waitToStart()
    if self.character:isAiming() then
        self.character:nullifyAiming()
    end
    if self.character:isSneaking() then
        self.character:setSneaking(false)
    end

    local dir = self:getFacingDirection()
    self.character:faceDirection(dir)
    if self.character:isTurning() then
        return true
    elseif self.character:shouldBeTurning() then
        self.delayCount = 0.3
    else
		if self.delayCount == nil then
			self.delayCount = 0.3
		end
        self.delayCount = self.delayCount - TABAS_GT.GameTime:getRealworldSecondsSinceLastUpdate()
        if self.delayCount > 0 then
            return true
        end
    end
    return self.character:shouldBeTurning()
end

function TABAS_ClimbOverTubEdge:update()
    if not self.tfc_Base then return end
    if self.enter then
        if not self.sound and self:getJobDelta() > 0.25 then
            local ratio = self.tfc_Base:getRatio() or 0
            if ratio > 0.4 then
                self.sound = self.character:getEmitter():playSound("tabas_bath_enter")
            elseif ratio > 0.1 then
                self.sound = self.character:getEmitter():playSound("tabas_bath_enter_low")
            else
                self.sound = true
            end
        end
    else
        if not self.sound and self:getJobDelta() > 0.1 then
            local ratio = self.tfc_Base:getRatio() or 0
            if ratio > self.tfc_Base.filledConst.HalfLow then
                self.sound = self.character:getEmitter():playSound("tabas_bath_exit")
            elseif ratio > self.tfc_Base.filledConst.Low then
                self.sound = self.character:getEmitter():playSound("tabas_walkintub01")
            else
                self.sound = true
            end
        end
    end
end

function TABAS_ClimbOverTubEdge:start()
    setGameSpeed(1)
    self:switchSquareSolid()
    self.started = true
    local dir = self:getFacingDirection()
    self:adjustPosition(dir)
    self.character:setbClimbing(true)
    self.character:climbOverFence(dir)
end

function TABAS_ClimbOverTubEdge:stop()
    self:switchSquareSolid()
    self.character:setbClimbing(false)
	ISBaseTimedAction.stop(self)
end

function TABAS_ClimbOverTubEdge:perform()
    self:switchSquareSolid()
    if self.character:isClimbing() then
        self.character:setbClimbing(false)
    end
    if self.enter then
        self.character:setIgnoreMovement(true)
    else
        self.character:setIgnoreMovement(false)
    end
    -- needed to remove from queue / start next.
    ISBaseTimedAction.perform(self)
end

function TABAS_ClimbOverTubEdge:complete()
    return true
end

function TABAS_ClimbOverTubEdge:adjustMaxTime(maxTime)
    return maxTime
end

function TABAS_ClimbOverTubEdge:new(character, climbObj, prevSqr, enter)
    local o = {}
    setmetatable(o, self)
    self.__index = self
    o.character = character
    o.enter = enter or false
    o.prevSqr = prevSqr
    o.targetSqr = climbObj:getSquare()
    o.tfc_Base = TABAS_Utils.getTfcBaseOnBathObject(climbObj)

    o.maxTime = 95
    -- o.stopOnWalk = false
    -- o.stopOnRun = false
    -- o.stopOnAim = false
    o.useProgressBar = false
    o.ignoreHandsWounds = true
    return o
end